/* -*- Mode:C; Tab-width:4 -*- */
/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 252.227-7013.          */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 149149                            */
/*                         AUSTIN, TEXAS 78714-9149                      */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C)   1987,1988,1989,1990 Texas Instruments Incorporated.  */
/*  All rights reserved.                                                 */
/*                                                                       */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#ifndef lint
static char sccsid[] = "@(#)pmap_getport.c 1.1 86/02/03 Copyr 1984 Sun Micro";
#endif

/*
 * pmap_getport.c
 * Client interface to pmap rpc service.
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 */

#include <rpc-types.h>
#include "::bsd:netinet:bsd-in.h"
#include "xdr.h"
#include "auth.h"
#include "clnt.h"
#include "rpc_msg.h"
#include "pmap_prot.h" 
#include "pmap_clnt.h"
#include "::bsd:sys:socket.h"
#include "::bsd:sys:time.h"
#include <stdio.h>
#include "::bsd:net:if.h"
#include "::bsd:arpa:inet.h"
#include <portmap.h>
#include <quickdraw.h>
#include <micronet-accessors.h>
#define NAMELEN 255

static struct timeval timeout = { 5, 0 };
static struct timeval tottimeout = { 60, 0 };

/*
 * Find the mapped port for program,version.
 * Calls the pmap service remotely to do the lookup.
 * Returns 0 if no map exists.
 */
u_short
pmap_getport(address, program, version, protocol)
	struct sockaddr_in *address;
	u_long program;
	u_long version;
	u_long protocol;
{
	u_short port = 0;
	int socket = -1;
	register CLIENT *client;
	struct pmap parms, *ioctl_parms[5];
	struct sockaddr_in my_address;


	get_myaddress(&my_address);

	address->sin_port = htons(PMAPPORT);

	parms.pm_prog = program;
	parms.pm_vers = version;
	parms.pm_prot = protocol;
	parms.pm_port = 0;  /* not needed or used */

	if(address->sin_addr.s_addr == my_address.sin_addr.s_addr)
	  {
		  /* Local call to portmapper. */
		  ioctl_parms[0] = &parms;
		  if(r_ioctl(DriverData->refnum, IOCTL_PMAP_GET, &ioctl_parms[0]))
			port = 0;
		  else
			port = parms.pm_port;		  
	  }
	else
	  {
		  if (address->sin_family == AF_MAC)
			client = clntmac_bufcreate(address, PMAPPROG, PMAPVERS, timeout, &socket, RPCSMALLMSGSIZE, RPCSMALLMSGSIZE);
		  if (client != (CLIENT *)NULL)
			{
				if (CLNT_CALL(client, PMAPPROC_GETPORT, xdr_pmap, &parms,
							  xdr_u_short, &port, tottimeout) != RPC_SUCCESS)
				  {
					  rpc_createerr.cf_stat = RPC_PMAPFAILURE;
					  clnt_geterr(client, &rpc_createerr.cf_error);
				  }
				else if (port == 0)
				  {
					  rpc_createerr.cf_stat = RPC_PROGNOTREGISTERED;
				  }
				CLNT_DESTROY(client);
			}
		  
		  sockclose(socket);
		  address->sin_port = 0;
	  }
	return (port);
}
